############################################################
# file iris-Koh.frg
#
# example file for the Frigate FuzzyCOPE scripting language
# creates, trains, recalls and saves Kohonens for iris data
#
# created on: 17/06/98
# created by: Mike Watts (mike@kel.otago.ac.nz)
#
# last modified on: 17/06/98
# last modified by: Mike Watts (mike@kel.otago.ac.nz)
############################################################

#commence command loggin
log start filename (iris-Koh.log)

#create the Kohonen, in this case a 2 dimensional 10 by 10 map
create Kohonen alias iris.net dimensions 2 inputs 4 mapdim {10, 10}

#save it
save Kohonen alias iris.net filename (iris-Koh-0.wgt)

#create the training object for it
create KohonenTrainer alias iris.koh network iris.net

#load the training data
load Data alias iris.lbl filename (iris.lbl)

#train the network
train alias iris.koh data iris.lbl epochs 100 LearningRate 0.9 neighbourhood {2, 2}

#save the trained network
save Kohonen alias iris.net filename (iris-Koh-100.wgt)

#create a map for the trained network
map network iris.net input iris.lbl output iris.map

#save the map
save Data alias iris.map filename (iris-100.map)

#recall the network, generating a coordinate set
recall network iris.net input iris.lbl output iris.cod

#save the coordinates
save Data alias iris.cod filename (iris-100.cod)

#generate a label set from the map and co-ordinates
label network iris.net map iris.map coord iris.cod output iris.out

#save the labels
save Data alias iris.out filename (iris-100.lbl)

#delete the output data objects
destroy iris.map
destroy iris.cod
destroy iris.out

#train for another 900 epochs
train alias iris.koh data iris.lbl epochs 900 LearningRate 0.9 neighbourhood {2, 2}

#save the trained network
save Kohonen alias iris.net filename (iris-Koh-1000.wgt)

#create a map for the trained network
map network iris.net input iris.lbl output iris.map

#save the map
save Data alias iris.map filename (iris-1000.map)

#recall the network, generating a coordinate set
recall network iris.net input iris.lbl output iris.cod

#save the coordinates
save Data alias iris.cod filename (iris-1000.cod)

#generate a label set from the map and co-ordinates
label network iris.net map iris.map coord iris.cod output iris.out

#save the labels
save Data alias iris.out filename (iris-1000.lbl)

#clean up the work space
purge

#terminate logging
log stop
