############################################################
# file iris-FuNN.frg
#
# example file for the Frigate FuzzyCOPE scripting language
# creates, trains, recalls and saves FuNNs for iris data
#
# created on: 17/06/98
# created by: Mike Watts (mike@kel.otago.ac.nz)
#
# last modified on: 17/06/98
# last modified by: Mike Watts (mike@kel.otago.ac.nz)
############################################################

#commence command logging
log start filename (iris-FuNN.log)

#create the FuNN
create FuNN alias iris.net inputs 4 condition {3, 3, 3, 3} rules 10 action {2, 2, 2} outputs 3

#save it
save FuNN alias iris.net filename (iris-FuNN-0.wgt)

#create the Bp training object for the network
create BPTrainer alias iris.bp network iris.net

#load the training data
load Data alias iris.trn filename (iris.trn)

#train the network
train alias iris.bp data iris.trn epochs 100 LearningRate 0.9 Momentum 0.5 mode pattern

#save the trained network
save FuNN alias iris.net filename (iris-FuNN-100.wgt)

#recall the trained network
recall network iris.net input iris.trn output iris.out

#save the output data
save Data alias iris.out filename (iris-FuNN-100.out)

#delete the output data
destroy iris.out

#train for another 900 epochs
train alias iris.bp data iris.trn epochs 900 LearningRate 0.9 Momentum 0.5 mode pattern

#save the network again
save FuNN alias iris.net filename (iris-FuNN-1000.wgt)

#recall the network
recall network iris.net input iris.trn output iris.out

#save the output data
save Data alias iris.out filename ( iris-FuNN-1000.out )

#clean up the work space
purge

#terminate logging
log stop
