############################################################
# file iris-MLP.frg
#
# example file for the Frigate FuzzyCOPE scripting language
# creates, trains, recalls and saves MLPs for iris data
#
# created on: 04/04/98
# created by: Mike Watts (mike@kel.otago.ac.nz)
#
# last modified on: 17/06/98
# last modified by: Mike Watts (mike@kel.otago.ac.nz)
############################################################

#commence command logging
log start filename (iris-MLP.log)

#create the MLP
create MLP alias iris.net layers 3 inputs 4 hidden {10} outputs 3 bias on

#save it
save MLP alias iris.net filename (iris-MLP-0.wgt)

#create the Bp training object for the network
create BPTrainer alias iris.bp network iris.net

#load the training data
load Data alias iris.trn filename (iris.trn)

#train the network
train alias iris.bp data iris.trn epochs 100 LearningRate 0.9 Momentum 0.5 mode pattern

#save the trained network
save MLP alias iris.net filename (iris-MLP-100.wgt)

#recall the trained network
recall network iris.net input iris.trn output iris.out

#save the output data
save Data alias iris.out filename (iris-MLP-100.out)

#delete the output data
destroy iris.out

#train for another 900 epochs
train alias iris.bp data iris.trn epochs 900 LearningRate 0.9 Momentum 0.5 mode pattern

#save the network again
save MLP alias iris.net filename (iris-MLP-1000.wgt)

#recall the network
recall network iris.net input iris.trn output iris.out

#save the output data
save Data alias iris.out filename ( iris-MLP-1000.out )

#clean up the work space
purge

#terminate logging
log stop
